/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OpeningBlock
extends DecorativeBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape NS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape EW_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    public static DecorativeBlock.ShapeFunction MIDDLE_AXIAL = (state, level, pos, context) -> state.m_61143_((Property)FACING) == Direction.NORTH || state.m_61143_((Property)FACING) == Direction.SOUTH ? NS_AABB : EW_AABB;

    public OpeningBlock(DecorativeBlock.Builder builder) {
        super(builder);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pState = (BlockState)pState.m_61122_((Property)OPEN);
        pLevel.m_7731_(pPos, pState, 10);
        pLevel.m_5898_(pPlayer, (Boolean)pState.m_61143_((Property)OPEN) != false ? 1006 : 1012, pPos, 0);
        pLevel.m_142346_((Entity)pPlayer, this.isOpen(pState) ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public boolean isOpen(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)OPEN);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean signal = pLevel.m_276867_(pPos);
        if (!this.m_49966_().m_60713_(pBlock) && signal != (Boolean)pState.m_61143_((Property)POWERED)) {
            if (signal != (Boolean)pState.m_61143_((Property)OPEN)) {
                pLevel.m_142346_(null, signal ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
            }
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        boolean signal = level.m_276867_(blockpos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(pContext))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(signal));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN, HINGE, POWERED});
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> EW_AABB;
            default -> NS_AABB;
        };
    }

    @Override
    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : this.m_5940_(pState, pLevel, pPos, pContext);
    }

    private DoorHingeSide getHinge(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Direction horizontalDirection = pContext.m_8125_();
        BlockPos above = clickedPos.m_7494_();
        Direction counterClockWise = horizontalDirection.m_122428_();
        BlockPos relativeCCW = clickedPos.m_121945_(counterClockWise);
        BlockState blockstateCCW = level.m_8055_(relativeCCW);
        BlockPos aboveCCW = above.m_121945_(counterClockWise);
        BlockState blockstateAboveCCW = level.m_8055_(aboveCCW);
        Direction horizontalDirectionCW = horizontalDirection.m_122427_();
        BlockPos posHorizontalCW = clickedPos.m_121945_(horizontalDirectionCW);
        BlockState blockstateHorizontalCW = level.m_8055_(posHorizontalCW);
        BlockPos aboveCW = above.m_121945_(horizontalDirectionCW);
        BlockState blockstateAboveCW = level.m_8055_(aboveCW);
        int i = (blockstateCCW.m_60838_((BlockGetter)level, relativeCCW) ? -1 : 0) + (blockstateAboveCCW.m_60838_((BlockGetter)level, aboveCCW) ? -1 : 0) + (blockstateHorizontalCW.m_60838_((BlockGetter)level, posHorizontalCW) ? 1 : 0) + (blockstateAboveCW.m_60838_((BlockGetter)level, aboveCW) ? 1 : 0);
        boolean CCW = blockstateCCW.m_60713_((Block)this);
        boolean CW = blockstateHorizontalCW.m_60713_((Block)this);
        if ((!CCW || CW) && i <= 0) {
            if ((!CW || CCW) && i == 0) {
                int j = horizontalDirection.m_122429_();
                int k = horizontalDirection.m_122431_();
                Vec3 vec3 = pContext.m_43720_();
                double d0 = vec3.f_82479_ - (double)clickedPos.m_123341_();
                double d1 = vec3.f_82481_ - (double)clickedPos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    public boolean isDiagonallyPlaceable() {
        return false;
    }
}

